unit FlyStr35;

interface

uses
  //  
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, ComCtrls, StdCtrls, ToolWin;

type TFlyStr  = class(TObject)
private
    // ----------------
    PanelFly   : TPanel;   //  
    ImgFly     : TImage;   //  Image   PanelFly
    // ----------------
    Timer      : TTimer;   //  
    fSrcFlyStr : string;   //    
    fBufFlyStr : string;   //    
    // ----------------
    //     ImgFly
    procedure FlyStr();
    //    
    procedure TimerTimer(Sender: TObject);
    //      ImgFly
    procedure ResizeImgFly();
    //      PanelFly
    procedure PanelFlyResize(Sender: TObject);
    //      ImgFly (  )
    procedure ImgFlyClick(Sender: TObject);
    //     
    procedure InitFlyStr();
public
     constructor Create(RqPanel : TPanel; RqImg : TImage);
     procedure Free;
     // ----------------
     procedure FlyStrON(RqON : boolean);
     //       *.txt
     procedure LoadFlyStr();
end;


implementation

// =========================================================================
//     
// =========================================================================
// -------------------------------------------------------------------------
constructor TFlyStr.Create(RqPanel : TPanel; RqImg : TImage);
begin
   inherited Create;
   PanelFly := RqPanel;
   PanelFly.OnResize := PanelFlyResize;
   ImgFly   := RqImg;
   ImgFly.OnClick := ImgFlyClick;
   Timer    := TTimer.Create(nil);
   Timer.Interval := 200;
   Timer.OnTimer  := TimerTimer;
   InitFlyStr();
end;

// -------------------------------------------------------------------------
procedure TFlyStr.Free;
begin
   Timer.Free;
   ImgFly.OnClick := nil;
   PanelFly.OnResize := nil;
   inherited Free;
end;
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// 17.11.2016
//     ImgFly
procedure TFlyStr.FlyStr();
var wR : TRect;
begin
   wR := ImgFly.Canvas.ClipRect;
   with ImgFly.Picture.Bitmap.Canvas
   do begin
     Brush.Color := ImgFly.Parent.Brush.Color;
     FillRect(Rect(0,0, ImgFly.Width, ImgFly.Height));
     TextOut(0,0, '  ' + fBufFlyStr);
   end;
end;
// -------------------------------------------------------------------------
// 17.11.2016
//    
procedure TFlyStr.TimerTimer(Sender: TObject);
var wChar : char;
begin
    wChar := fBufFlyStr[1];
    fBufFlyStr := Copy(fBufFlyStr, 2, Length(fBufFlyStr)-1);
    fBufFlyStr := fBufFlyStr + wChar;
    FlyStr();
end;

// -------------------------------------------------------------------------
// 17.11.2016
//     
procedure TFlyStr.InitFlyStr();
begin
   Timer.Enabled := False;
   PanelFly.Visible := False;
   fSrcFlyStr := '      ...';
   fBufFlyStr := fSrcFlyStr;
   with ImgFly.Canvas
   do begin
      Font.Name := 'Arial';
      Font.Size := 10;
      Font.Style := [fsBold,fsItalic];
      Font.Color := RGB(32,64,127);
      Brush.Color := ImgFly.Parent.Brush.Color;
      FillRect(Rect(0,0, ImgFly.Width, ImgFly.Height));
    end;
end;
// -------------------------------------------------------------------------
// 17.11.2016
//      ImgFly
procedure TFlyStr.ResizeImgFly();
begin
  ImgFly.Left  := 10;
  ImgFly.Width := PanelFly.Width - 2 * ImgFly.Left;
   with ImgFly.Picture.Bitmap
   do begin
      PanelFly.Height := Canvas.TextHeight(fSrcFlyStr) + 8;
      ImgFly.Height := PanelFly.Height - 4;
      ImgFly.Top := 2;
      Width  := ImgFly.Width;
      Height := ImgFly.Height;
      Canvas.FillRect(Rect(0,0, ImgFly.Width, ImgFly.Height));
      fBufFlyStr := fSrcFlyStr + '   ';
      while Canvas.TextWidth(fBufFlyStr) < Width
      do fBufFlyStr := fBufFlyStr + ' ';
  end;
end;
// -------------------------------------------------------------------------
// 17.11.2016
//      PanelFly
procedure TFlyStr.PanelFlyResize(Sender: TObject);
begin
  ResizeImgFly();
end;
// -------------------------------------------------------------------------
// 17.11.2016
//      ImgFly (  )
procedure TFlyStr.ImgFlyClick(Sender: TObject);
var Dialog : TFontDialog;
begin
  Dialog := TFontDialog.Create(nil);
    Dialog.Font.Name := 'Arial';
    Dialog.Font.Size := 10;
    Dialog.Font.Style := [fsBold,fsItalic];
    if Dialog.Execute
    then begin
      ImgFly.Canvas.Font := Dialog.Font;
      ResizeImgFly();
    end;
  Dialog.Free;
end;
// -------------------------------------------------------------------------
// 17.11.2016
//       *.txt
procedure TFlyStr.LoadFlyStr();
var Dialog  : TOpenDialog;
    TxtFile : TextFile;
    BufStr  : string;
begin
    Dialog := TOpenDialog.Create(nil);
    Dialog.Filter :=  '    (*.txt ) |*.TXT';
    if Dialog.Execute
    then begin
      try
       AssignFile(TxtFile, Dialog.FileName);
       Reset(TxtFile);
       fSrcFlyStr := ' ';
       while not Eof(TxtFile)
       do begin
          Readln(TxtFile, BufStr);
          fSrcFlyStr := fSrcFlyStr + ' ' + BufStr;
       end;
       ResizeImgFly();
       FlyStrON(True);
      finally
       CloseFile(TxtFile);
      end;
    end;
    if Assigned(Dialog) then Dialog.Free;
end;
// -------------------------------------------------------------------------
// 17.11.2016
procedure TFlyStr.FlyStrON(RqON : boolean);
begin
   Timer.Enabled := RqON;
   PanelFly.Visible := RqON;
end;
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------



procedure MMFlayStrEnabledClick(Sender: TObject);
begin
{
    MMFlayStrEnabled.Checked := not MMFlayStrEnabled.Checked;
    FlyStrON(MMFlayStrEnabled.Checked);
}
end;

procedure MMFlyStrLoadClick(Sender: TObject);
begin
{
    LoadFlyStr();
    MMFlayStrEnabled.Checked := True;
}
end;



end.
